/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_4844;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ILootrInfo {
    public static final Set<Class<?>> WARNED_CLASSES = new HashSet();
    public static final Codec<ILootrInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootrBlockType.CODEC.optionalFieldOf("blockType").forGetter(in -> Optional.ofNullable(in.getInfoBlockType())), (App)LootrInfoType.CODEC.optionalFieldOf("type").forGetter(in -> Optional.ofNullable(in.getInfoType())), (App)ILootrType.CODEC.optionalFieldOf("newType").forGetter(in -> Optional.ofNullable(in.getInfoNewType())), (App)class_4844.field_25122.fieldOf("uuid").forGetter(ILootrInfo::getInfoUUID), (App)Codec.STRING.fieldOf("key").forGetter(ILootrInfo::getInfoKey), (App)class_2338.field_25064.fieldOf("position").forGetter(ILootrInfo::getInfoPos), (App)class_8824.field_46597.optionalFieldOf("name").forGetter(i -> Optional.ofNullable(i.getInfoDisplayName())), (App)class_2960.field_25139.xmap(loc -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)loc), class_5321::method_29177).fieldOf("dimension").forGetter(ILootrInfo::getInfoDimension), (App)Codec.INT.fieldOf("size").forGetter(ILootrInfo::getInfoContainerSize), (App)class_1799.field_49266.listOf().xmap(list -> class_2371.method_10212((Object)class_1799.field_8037, (Object[])list.toArray(new class_1799[0])), list -> list).optionalFieldOf("reference").forGetter(info -> info.isInfoReferenceInventory() ? Optional.ofNullable(info.getInfoReferenceInventory()) : Optional.empty()), (App)class_2960.field_25139.xmap(loc -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)loc), class_5321::method_29177).optionalFieldOf("table").forGetter(i -> Optional.ofNullable(i.getInfoLootTable())), (App)Codec.LONG.optionalFieldOf("seed").forGetter(info -> info.getInfoLootTable() != null ? Optional.of(info.getInfoLootSeed()) : Optional.empty())).apply((Applicative)instance, BaseLootrInfo::new));

    @Deprecated
    @Nullable
    public LootrBlockType getInfoBlockType();

    @Deprecated
    @Nullable
    public LootrInfoType getInfoType();

    @Nullable
    public ILootrType getInfoNewType();

    default public LootFiller getDefaultFiller() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return DefaultLootFiller.getInstance();
        }
        return type.getDefaultFiller();
    }

    default public boolean canRefresh() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canRefresh();
    }

    default public boolean canDecay() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canDecay();
    }

    default public boolean canBeMarkedUnopened() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canBeMarkedUnopened();
    }

    default public boolean canDropContentsWhenBroken() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canDropContentsWhenBroken();
    }

    @Deprecated
    @Nullable
    default public class_2248 getReplacementBlock() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return null;
        }
        return type.getReplacementBlock();
    }

    @Deprecated
    @Nullable
    default public class_1299<?> getReplacementEntity() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return null;
        }
        return type.getReplacementEntity();
    }

    @Deprecated
    default public boolean isEntity() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return false;
        }
        return type.isEntity();
    }

    @NotNull
    default public class_243 getInfoVec() {
        return class_243.method_24953((class_2382)this.getInfoPos());
    }

    @NotNull
    public UUID getInfoUUID();

    public String getInfoKey();

    public static String generateInfoKey(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public boolean hasBeenOpened();

    public boolean isPhysicallyOpen();

    @NotNull
    public class_2338 getInfoPos();

    @Nullable
    public class_2561 getInfoDisplayName();

    @NotNull
    public class_5321<class_1937> getInfoDimension();

    public int getInfoContainerSize();

    @Nullable
    public class_2371<class_1799> getInfoReferenceInventory();

    default public boolean canPlayerOpen(class_3222 player) {
        return true;
    }

    default public void informPlayerCannotOpen(class_3222 player) {
    }

    public boolean isInfoReferenceInventory();

    @Nullable
    public class_5321<class_52> getInfoLootTable();

    public long getInfoLootSeed();

    default public class_1937 getInfoLevel() {
        if (!WARNED_CLASSES.contains(this.getClass())) {
            LootrAPI.LOG.error("Class {} does not implement `getInfoLevel`! Falling back on `getDefaultLevel`.", (Object)this.getClass().getName());
            WARNED_CLASSES.add(this.getClass());
        }
        return this.getDefaultLevel();
    }

    @Nullable
    default public class_1937 getDefaultLevel() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            return null;
        }
        return server.method_3847(this.getInfoDimension());
    }

    @Nullable
    default public class_1263 getInfoContainer() {
        class_3218 level;
        class_1937 class_19372 = this.getInfoLevel();
        if (!(class_19372 instanceof class_3218) || (level = (class_3218)class_19372).method_8608()) {
            return null;
        }
        if (this.getInfoNewType() == null) {
            class_2586 be = level.method_8321(this.getInfoPos());
            if (be instanceof class_1263) {
                class_1263 container = (class_1263)be;
                return container;
            }
            class_1297 entity = level.method_66347(this.getInfoUUID());
            if (entity instanceof class_1263) {
                class_1263 container = (class_1263)entity;
                return container;
            }
            LootrAPI.LOG.warn("Unable to guess container type for LootrInfo with key '{}'", (Object)this.getInfoKey());
            return null;
        }
        return this.getInfoNewType().getContainer(this, level);
    }

    default public class_2371<class_1799> buildInitialInventory() {
        return class_2371.method_10213((int)this.getInfoContainerSize(), (Object)class_1799.field_8037);
    }

    @Deprecated
    public static enum LootrInfoType implements class_3542
    {
        CONTAINER_BLOCK_ENTITY,
        CONTAINER_ENTITY;

        public static final Codec<LootrInfoType> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(LootrInfoType::values);
        }
    }
}

